package com.example.disttone;

import android.os.Bundle;
import android.widget.TextView;

import androidx.appcompat.app.AppCompatActivity;

import java.util.ArrayList;

public class LogActivity extends AppCompatActivity {

    TextView logView;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_log);

        logView = findViewById(R.id.log_view);
        LogDatabase logDatabase = new LogDatabase(LogActivity.this);

        // get all the records in an array
        ArrayList<ALogRecord> showAllRecords = logDatabase.returnAllLogRecords();

        // check if array is empty
        if (showAllRecords.size() > 0) {
            // get all records formatted in descendant order
            for (ALogRecord rec : showAllRecords) {
                logView.append(rec.getLog_id() + " | " +  rec.getLog_beepFreq() + " | " +
                        rec.getLog_beep_duration() + " | " +  rec.getLog_feedbackBeepFreq() + " | " +
                        rec.getLog_sysTimeOut() + " | " +  rec.getLog_sysTimeIn() + " | " +
                        rec.getLog_delay() + " | " +  rec.getLog_airTemp() + " | " +
                        rec.getLog_distance() + " | " +  rec.getLog_phoneDate() );
                logView.append("\n");
                logView.append(getResources().getString(R.string.log_separation));
                logView.append("\n");
            }
            
            logView.append("- - - < End of records > - - -");
        }
    }

}