package com.example.disttone;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

import java.util.ArrayList;

public class LogDatabase extends SQLiteOpenHelper {
    private static final int DATABASE_VERSION = 1;
    public static final String DATABASE_NAME = "log_db";
    public static final String DATA_TABLE_NAME = "data";
    public static final String DATA_ID = "data_id";
    public static final String DATA_BEEPFREQ = "data_beepFreq";
    public static final String DATA_BEEP_DURATION = "data_beep_duration";
    public static final String DATA_FEEDBACKBEEPFREQ = "data_feedbackBeepFreq";
    public static final String DATA_SYSTIMEOUT = "data_sysTimeOut";
    public static final String DATA_SYSTIMEIN = "data_sysTimeIn";
    public static final String DATA_DELAY = "data_delay";
    public static final String DATA_AIRTEMP = "data_airTemp";
    public static final String DATA_DISTANCE = "data_distance";
    public static final String DATA_PHONEDATE = "data_phoneDate";

    //constructor
    public LogDatabase(Context context) {
        super(context, DATABASE_NAME, null, DATABASE_VERSION);
    }

    // create the table
    @Override
    public void onCreate(SQLiteDatabase database) {
        database.execSQL("CREATE TABLE " + DATA_TABLE_NAME + " (" +
                DATA_ID + " INTEGER PRIMARY KEY AUTOINCREMENT, " +
                DATA_BEEPFREQ + " TEXT, " +
                DATA_BEEP_DURATION + " TEXT, " +
                DATA_FEEDBACKBEEPFREQ + " TEXT," +
                DATA_SYSTIMEOUT + " TEXT," +
                DATA_SYSTIMEIN + " TEXT," +
                DATA_DELAY + " TEXT," +
                DATA_AIRTEMP + " TEXT," +
                DATA_DISTANCE + " TEXT," +
                DATA_PHONEDATE + " TEXT" + ")");
    }

    // upgrade table to a new version
    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        db.execSQL("DROP TABLE IF EXISTS " + DATA_TABLE_NAME);
        onCreate(db);
    }

    // add record
    public void addLogRecord (ALogRecord ALogRecordLine) {
        SQLiteDatabase db = getWritableDatabase();
        String query =  "INSERT INTO " + DATA_TABLE_NAME + " VALUES (null, '" + ALogRecordLine.getLog_beepFreq() +
                "', '" + ALogRecordLine.getLog_beep_duration() +
                "', '" + ALogRecordLine.getLog_feedbackBeepFreq() +
                "', '" + ALogRecordLine.getLog_sysTimeOut() +
                "', '" + ALogRecordLine.getLog_sysTimeIn() +
                "', '" + ALogRecordLine.getLog_delay() +
                "', '" + ALogRecordLine.getLog_airTemp() +
                "', '" + ALogRecordLine.getLog_distance() +
                "', '" + ALogRecordLine.getLog_phoneDate() +
                "')";

        db.execSQL(query);
        db.close();
    }

    // delete record
    public void deleteLogRecord(int id) {
        SQLiteDatabase db = getWritableDatabase();
        String deleteLogRecord = "DELETE FROM " + DATA_TABLE_NAME +
                " WHERE " + DATA_ID + " = " + id;

        db.execSQL(deleteLogRecord);
        db.close();
    }

    // delete ALL records
    public long deleteAllLogRecords() {
        SQLiteDatabase db = getWritableDatabase();
        //clause where 1 is to return the number of deleted rows, normally is null
        long noRows = db.delete(DATA_TABLE_NAME, "1", null);
        db.close();
        return noRows;
    }

    // update record, not used but who knows
    public void updateLogRecord(int id, String s1, String s2) {
        SQLiteDatabase db = getWritableDatabase();
        String query = "UPDATE " + DATA_TABLE_NAME +
                " SET " + DATA_BEEPFREQ + " = '" + s1 +
                "', " + DATA_BEEP_DURATION + " = '" + s2 +
                "' " + "WHERE " + DATA_ID + " = " + id;

        db.execSQL(query);
        db.close();
    }

    // return all records
    public ArrayList<ALogRecord> returnAllLogRecords() {
        SQLiteDatabase database = getWritableDatabase();
        String query = "SELECT * FROM " + DATA_TABLE_NAME + " ORDER BY " + DATA_ID + " DESC";
        Cursor cursor = database.rawQuery(query, null);

        ArrayList<ALogRecord> allALogRecords = new ArrayList<>();

        while (cursor.moveToNext()) {
            ALogRecord currentLogRecord = new ALogRecord(
                    Integer.parseInt(cursor.getString(0)), cursor.getString(1),
                    cursor.getString(2), cursor.getString(3), cursor.getString(4),
                    cursor.getString(5), cursor.getString(6), cursor.getString(7),
                    cursor.getString(8), cursor.getString(9));
            allALogRecords.add(currentLogRecord);
        }

        cursor.close();
        database.close();

        return allALogRecords;
    }

}
