/*
* distTone by
* soryn [at] email [dot] com
* disttone [dot] bitkeys [dot] net
*/

package com.example.disttone;

import android.Manifest;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioRecord;
import android.media.AudioTrack;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.SystemClock;
import android.text.Editable;
import android.text.TextWatcher;
import android.text.method.LinkMovementMethod;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.Window;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;

public class MainActivity extends AppCompatActivity {

    // define user interface elements and general variables
    EditText beepFreq,feedbackBeepFreq, beepDuration, airTemp, delayOffset;
    TextView feedbackFreq, beepEmittedDuration, feedbackDuration, sysTimeOut, sysTimeIn, delay, distance;
    Button beepPlay, beepCancel;
    SeekBar delayOffsetSeekbar;
    CheckBox oneLoopBox;
    AudioTrack beep, beepReturn;
    LogDatabase logDatabase;

    // same value of "storedSettings" in all activities, to share settings/preferences between them
    public static final String savedSettings = "storedSettings";

    // audio thread
    private static final int REQUEST_PERMISSIONS = 1;
    final String logMsg = "Log";
    private Audio audio;
    boolean lock;
    boolean oneLoop;
//    int comparator;
    long beepStartTime, beepReceptionTime, beepFeedbackTime;


    /*************** ANDROID *************/

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        // call defined views
        setViews();

        // get latest values entered in interface EditText's
        beepFreq.setText(getSettingsValue("beepFreq", "4300"));
        beepDuration.setText(getSettingsValue("beepDuration", "500"));
        feedbackBeepFreq.setText(getSettingsValue("feedbackBeepFreq", "4000"));
        airTemp.setText(getSettingsValue("airTemp", "0.5"));
        delayOffset.setText(getSettingsValue("delayOffset", "1.00"));
        delayOffsetSeekbar.setProgress(Math.round(Float.parseFloat(delayOffset.getText().toString()) * 100f));

        // create onClick listeners for buttons using a class
        beepPlay.setOnClickListener(new OnClickButton());
        beepCancel.setOnClickListener(new OnClickButton());
        oneLoopBox.setOnClickListener(new OnClickButton());

        // create onTextChange listeners using a class, to save latest values entered with SharedPreferences
        beepFreq.addTextChangedListener(new OnTextChange());
        beepDuration.addTextChangedListener(new OnTextChange());
        feedbackBeepFreq.addTextChangedListener(new OnTextChange());
        airTemp.addTextChangedListener(new OnTextChange());
        delayOffset.addTextChangedListener(new OnTextChange());

        // create the audio object with Audio class, listen for beeps (feedback loop)
        audio = new Audio();
//        comparator = getFreq();

        // create the database object
        logDatabase = new LogDatabase(MainActivity.this);

        // seekBar linked with EditText and the other way around
        delayOffsetSeekbar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {
            @Override
            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                float decimalVal = (float) ((float)progress / 100.0);
                delayOffset.setText(String.valueOf(decimalVal));
            }
            @Override
            public void onStartTrackingTouch(SeekBar seekBar) {}
            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {}
        });

    }

    @Override
    protected void onPause(){
        super.onPause();
        // stop audio thread
        audio.stop();
    }

    @Override
    protected void onResume() {
        super.onResume();
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            if (checkSelfPermission(Manifest.permission.RECORD_AUDIO) != PackageManager.PERMISSION_GRANTED) {
                requestPermissions(new String[] {Manifest.permission.RECORD_AUDIO}, REQUEST_PERMISSIONS);
                return;
            }
        }

        // Start the audio thread
        audio.start();
    }

    // check manifest for granted permissions and SDK version
    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == REQUEST_PERMISSIONS) {
            for (int i = 0; i < grantResults.length; i++) {
                if (permissions[i].equals(Manifest.permission.RECORD_AUDIO) && grantResults[i] == PackageManager.PERMISSION_GRANTED) {
                    //  Granted, recreate or start audio thread
                    if (Build.VERSION.SDK_INT != Build.VERSION_CODES.M) {
                        recreate();
                    } else {
                        audio.start();
                    }
                }
            }
        }
    }

    // create menu
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater menuInflater = getMenuInflater();
        menuInflater.inflate(R.menu.main_menu,menu);
        return true;
    }

    // menu actions
    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()){
            case R.id.log:
                // start log activity
                Intent gameIntent = new Intent(getBaseContext(),LogActivity.class);
                startActivity(gameIntent);
//                Toast.makeText(this, R.string.menu_log,Toast.LENGTH_SHORT).show();
                return true;

            case R.id.weblog:
                // start browser with url to view online data
                Intent webLog = new Intent(Intent.ACTION_VIEW);
//                webLog.addCategory(Intent.CATEGORY_BROWSABLE);
                webLog.setData(Uri.parse("https://disttone.bitkeys.net/raw_data.php"));
                startActivity(webLog);
                return true;

            case R.id.settings:
                // start settings activity
                Intent settingsIntent = new Intent(getBaseContext(),SettingsActivity.class);
                startActivity(settingsIntent);
//                Toast.makeText(this, R.string.menu_settings,Toast.LENGTH_SHORT).show();
                return true;

            case R.id.help:
                // show help popup
                ViewPopup showHelp = new ViewPopup();
                showHelp.showDialog(this, "Help", getText(R.string.help_text));
                return true;

            case R.id.about:
                // show about popup
                ViewPopup showAbout = new ViewPopup();
                showAbout.showDialog(this, "About", getText(R.string.about_text));
                return true;

            default:
                return super.onContextItemSelected(item);
        }
    }


    /*************** GET/SET VALUES *************/

    // link objects with the view (user interface)
    void setViews(){
        airTemp = findViewById(R.id.air_temp);
        beepFreq = findViewById(R.id.beep_freq);
        feedbackBeepFreq = findViewById(R.id.feedbackBeep_freq);
        beepDuration = findViewById(R.id.beep_duration);
        beepPlay = findViewById(R.id.beep_play);
        beepCancel = findViewById(R.id.beep_cancel);
        feedbackFreq = findViewById(R.id.feedback_freq);
        beepEmittedDuration = findViewById(R.id.beep_emitted_duration);
        feedbackDuration = findViewById(R.id.feedback_duration);
        sysTimeOut = findViewById(R.id.sys_time_out);
        sysTimeIn = findViewById(R.id.sys_time_in);
        delay = findViewById(R.id.delay);
        distance = findViewById(R.id.distance);
        delayOffset = findViewById(R.id.delayOffset);
        delayOffsetSeekbar = findViewById(R.id.delayOffsetSeekbar);
        oneLoopBox = findViewById(R.id.oneLoop);
    }

    // getDate
    String getDate() {
        @SuppressLint("SimpleDateFormat") SimpleDateFormat dateTime = new SimpleDateFormat("dd-MMM-yyyy'T'HH:mm:ss");
//        return System.currentTimeMillis() / 1000;
        return dateTime.format(new Date());
    }

    // get frequency value for tone generator from text box or a default value
    int getFreq() {
        String textValue = beepFreq.getText().toString();
        if (textValue.isEmpty())
            textValue = "4300";
        return Integer.parseInt(textValue);
    }

    // get tone duration value for tone generator from text box or a default value
    int getDuration() {
        String textValue = beepDuration.getText().toString();
        if (textValue.isEmpty())
            textValue = "500";
        return Integer.parseInt(textValue);
    }

    // get ambiance temperature value for sound speed formula from text box or a default value
    double getTemp(){
        String textValue = airTemp.getText().toString();
        if (textValue.isEmpty()){
            textValue = "0.5";
        }
        return Double.parseDouble(textValue);
    }

    // get feedback frequency from text box or a default value
    int getfeedbackFreq(){
        String textValue = feedbackBeepFreq.getText().toString();
        if(textValue.isEmpty())
            textValue = "4000";
        return Integer.parseInt(textValue);
    }

    // get feedback frequency offset from local storage savedSettings = "storedSettings" set by SettingsActivity
    int getfeedbackFreqOffset() {
//        if (x == null){
//            return 5;
//        }
//        String textValue = x.getText().toString();
//        if(textValue.isEmpty())
//            textValue = "5";
        return Integer.parseInt(getSettingsValue("freqOffset","5"));
    }

    // get the delayOffsetValue to adjust the delay value and the distance calculation
    double getDelayOffsetValue () {
        return Double.parseDouble(getSettingsValue("delayOffset","3.83"));
    }


    /*************** EVENTS & FUNCTIONS *************/

    // capture onClick events; DEFINE THEM in onCreate!!
    private class OnClickButton implements View.OnClickListener {
        @Override
        public void onClick(View v) {
            // play button
            if(v == beepPlay) {
                // create the tone when click the play button to read the new entered values
                beep = beepGenerator(getFreq(), getDuration());

                // play the beep
                beep.play();

                // get the start time of playing beep and display it
                beepStartTime = SystemClock.uptimeMillis();
                sysTimeOut.setText(String.valueOf(beepStartTime));

                // show the beep duration
//                getBeepDuration();

                //unlock the frequency thread
                lock = false;
//
//                  long timeDifference = (beepReceptionTime - beepStartTime) / 1000000;
//                  sysTimeIn.setText(String.valueOf(timeDifference));
//  //  //                  Log.d(logMsg, "result: " + result);
//                  float calculatedBeepDuration = beep.getPlaybackHeadPosition() / playbackRate * 1000;
//  //                  beepEmittedDuration.setText(String.valueOf(playbackHead+8));
//                  beepEmittedDuration.setText(String.valueOf(calculatedBeepDuration));
//  //
//  //                  Log.d(logMsg, "beep0: " + calculatedBeepDuration + "_" + beep.getPlaybackHeadPosition());

                //  wait until beep plays
//                  try {
//                      Thread.sleep(getDuration());
//                  } catch (InterruptedException e) {
//                      e.printStackTrace();
//                  }

                //  time elapsed
//                  long output = lEndTime - lStartTime;

                //  display results
//                  sysTimeIn.setText(String.valueOf(lEndTime));
//                  feedbackDuration.setText(String.valueOf(output / 1000000));
//                 Log.d(logMsg, "beep1: " + beep.getPlaybackRate() + "_" + beep.getPlaybackHeadPosition() + "-" + beep.setNotificationMarkerPosition(1));
//                 Log.d(logMsg, "beep length: " + (1.0 / (beep.getPlaybackRate() / beep.getPlaybackHeadPosition())));
//                 Log.d(logMsg, "beep length: " + output / 1000000);

//               if(beep.toString().isEmpty()){
//
//               }
//                 final Thread thread = new Thread(new Runnable() {
//                     public void run() {
//                         beep = generateTone(getFreq(), getDuration());
//                         handler.post(new Runnable() {
//                             public void run() {
//                                 beep.play();
//                             }
//                         });
//                     }
//                 });
//                 thread.start();
            }

            // cancel button
            if(v == beepCancel) {
                // save locally data as logs, in SQLite database
                addLogRecordToLocalDatabase();

                // send data to the server
                addLogRecordToWebServer("https://temporary236887.bitkeys.net/insert_data.php");

                // lock/stop the audio thread and reset some values
                lock = true;
                if (beepReturn == null) {
                    Toast.makeText(getBaseContext(), "Beep has not been created!", Toast.LENGTH_SHORT).show();
                    return;
                }
                if (beepReturn.getState() != AudioTrack.STATE_INITIALIZED) {
//                    Toast.makeText(getBaseContext(), "Empty beepReturn!", Toast.LENGTH_SHORT).show();
                    beepReturn.release();
                    return;
                }
                beepReturn.pause();
                beepReturn.flush();
                beepReturn.release();
//                Audio resetComparator = new Audio();
//                resetComparator.comparator = getFreq();
//                comparator = getFreq();

                // avoid multiple press of cancel button errors
                if (beep == null){
                    Toast.makeText(getBaseContext(), "Beep has not been created!", Toast.LENGTH_SHORT).show();
                    return;
                }
                if (beep.getState() != AudioTrack.STATE_INITIALIZED) {
                    beep.release();
                    Toast.makeText(getBaseContext(), "Empty beep!", Toast.LENGTH_SHORT).show();
                    return;
                }

                // used pause() for instant stop
                beep.pause();

                // show the duration of canceled beep
                getBeepDuration();

                // empty the beepGenerator audio track and release the resource to the system
                beep.flush();
                beep.release();
                Toast.makeText(getBaseContext(), "Beep canceled!", Toast.LENGTH_SHORT).show();
            }

            // oneLoop checkbox, unlock audio listening and get current value
            if (v == oneLoopBox) {
                lock = false;
                oneLoop = oneLoopBox.isChecked();
            }
        }
    }

    // capture onTextChange events with only one class but different instances for each EditText
    private class OnTextChange implements TextWatcher {
        @Override
        public void beforeTextChanged(CharSequence s, int start, int count, int after) {}
        @Override
        public void onTextChanged(CharSequence s, int start, int before, int count) {
            if (s == delayOffset.getEditableText()) {
                // show on seekbar, convert float to int
              int prog = Math.round(Float.parseFloat(s.toString()) * 100f);
              delayOffsetSeekbar.setProgress(prog);
            }
        }

        @Override
        public void afterTextChanged(Editable s) {
            if (s == beepFreq.getEditableText()) {
                setSettingsValue("beepFreq", beepFreq.getText().toString());
            } else if (s == beepDuration.getEditableText()) {
                setSettingsValue("beepDuration", beepDuration.getText().toString());
            } else if (s == feedbackBeepFreq.getEditableText()) {
                setSettingsValue("feedbackBeepFreq", feedbackBeepFreq.getText().toString());
            } else if (s == airTemp.getEditableText()) {
                setSettingsValue("airTemp", airTemp.getText().toString());
            } else if (s == delayOffset.getEditableText()) {
                setSettingsValue("delayOffset", delayOffset.getText().toString());
            }
        }
    }

    // get settings using SharedPreferences internal storage from savedSettings = "storedSettings"
    public String getSettingsValue(String editedParamKey, String defaultVal) {
        SharedPreferences settings = getSharedPreferences(savedSettings,0);
        return settings.getString(editedParamKey,defaultVal);
    }

    // set settings using SharedPreferences internal storage in savedSettings = "storedSettings"
    public void setSettingsValue(String editedParamKey, String editedParamKeyValue) {
        SharedPreferences.Editor editor = getSharedPreferences(savedSettings,0).edit();
        editor.putString(editedParamKey, editedParamKeyValue);
        editor.apply();
    }

    // add log record to web server
    private void addLogRecordToWebServer(String urlString) {
        //string processed by php script on receiving
        String insertData = "?1=" + beepFreq.getText() + "&2=" + beepDuration.getText() + "&3=" + feedbackBeepFreq.getText() +
                "&4=" + sysTimeOut.getText() + "&5=" + sysTimeIn.getText() + "&6=" + delay.getText() +
                "&7=" + airTemp.getText() + "&8=" + distance.getText() + "&9=" + getDate();
        //create a sending object
        CallHttpRequest sendData = new CallHttpRequest();
        // send final url
        String[] url = {urlString + insertData};
        sendData.execute(url);
    }

    // add log record to local SQLite database [ /data/data/com.example.disttone/databases/log_db ]
    private void addLogRecordToLocalDatabase() {
        //get all strings to be recorded
        String s1 = beepFreq.getText().toString();
        String s2 = beepDuration.getText().toString();
        String s3 = feedbackBeepFreq.getText().toString();
        String s4 = sysTimeOut.getText().toString();
        String s5 = sysTimeIn.getText().toString();
        String s6 = delay.getText().toString();
        String s7 = airTemp.getText().toString();
        String s8 = distance.getText().toString();
        String s9 = getDate();

        try {
            ALogRecord logRecord = new ALogRecord(0, s1, s2, s3, s4, s5, s6, s7, s8, s9);
            logDatabase.addLogRecord(logRecord);
            Toast.makeText(getBaseContext(), logRecord + " has been added in log database",
                    Toast.LENGTH_SHORT).show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    // get beep duration to be displayed using the AudioTrack parameters to get the end of beep
    void getBeepDuration() {
        //if beep stopped, get the current emitted duration
        assert beep != null;
        if (beep.getPlayState() != AudioTrack.PLAYSTATE_PAUSED) {
                // setNotificationMarkerPosition(frames); for beep tracking: set the played buffer size in frames(bytes/2) not bytes
                beep.setNotificationMarkerPosition((int) (44100.0 * (getDuration() / 1000.0)) & ~1);

                // setPlaybackPositionUpdateListener will check AudioTrack position, beep frames position
                beep.setPlaybackPositionUpdateListener(new AudioTrack.OnPlaybackPositionUpdateListener() {
                    @Override
                    public void onPeriodicNotification(AudioTrack track) {
                        // this method even not used, have to be here
                    }

                    //will check if the previous marker position value has reach the end (filled up)
                    @Override
                    public void onMarkerReached(AudioTrack track) {
//                    // get the end time of playing beep
//                    beepFeedbackTime = SystemClock.uptimeMillis();
//                    long time = (beepFeedbackTime - beepStartTime);
//                    sysTimeOut.setText(String.valueOf(time));

                        //display the duration of played beep
                        long calculatedBeepDuration = Math.round(beep.getPlaybackHeadPosition() / 44100.0 * 1000);
//                        beepEmittedDuration.setText(String.valueOf(calculatedBeepDuration));
                    Log.d(logMsg, "the beep have been played!" + beep.getPlaybackHeadPosition());
                        beep.flush();
                        beep.release();
                    }
                });

            } else {
//            // get the end time of playing beep
//            beepFeedbackTime = SystemClock.uptimeMillis();
//            long time = (beepFeedbackTime - beepStartTime);
//            sysTimeOut.setText(String.valueOf(time));

                //display the duration of played beep
                long calculatedBeepDuration = Math.round(beep.getPlaybackHeadPosition() / 44100.0 * 1000);
//                beepEmittedDuration.setText(String.valueOf(calculatedBeepDuration));
            }
    }

    // tone generator function; Usage: AudioTrack tone = generateTone(1432, 250); tone.play();
    // [inspired from: https://gist.github.com/slightfoot/6330866; accessed: June 2020]
    private AudioTrack beepGenerator(double freqHz, int durationMs) {
        // create a counter(size) which implement duration of tone/beep
        // & ~1 Bitwise AND (&) Bitwise Complement (~) always return an even number closer to the input,
        // try 911 ms which is 40131 and get back 40174 (as 912 will be 40175.1)
        int size = (int)(44100.0 * (durationMs / 1000.0)) & ~1;

        // create the samples array of audio data of a size regarding duration
        short[] samples = new short[size];

        // fill the buffer/stream
        for(int i = 0; i < size; i ++){
            short sample = (short)(Math.sin(2 * Math.PI * i / (44100.0 / freqHz)) * 0x7FFF);
            samples[i] = sample;
        }

        // create the audio track
        AudioTrack toneTrack = new AudioTrack(AudioManager.STREAM_MUSIC, 44100,
                AudioFormat.CHANNEL_OUT_MONO, AudioFormat.ENCODING_PCM_16BIT,
                size * (Short.SIZE / 8), AudioTrack.MODE_STATIC);

        // Writes the audio data to the audio sink for playback (streaming mode),
        //  or copies audio data for later playback (static buffer mode)
        toneTrack.write(samples, 0, size);

        //  Check state, if any error, cancel it
        int state = toneTrack.getState();
        if (state != AudioTrack.STATE_INITIALIZED) {
            toneTrack.release();
            Toast.makeText(getBaseContext(), "Beep can't be generated!",Toast.LENGTH_SHORT).show();
        }

        // return prepared (written in hardware buffer) toneTrack to be played
        return toneTrack;
    }

    // show alert
    void showAlert(int alertMsg) {
        // Create an alert dialog builder
        AlertDialog.Builder builder = new AlertDialog.Builder(this);
        // Set the title, message and button
        builder.setTitle(R.string.app_name);
        builder.setMessage(alertMsg);
        builder.setNeutralButton("Ok", (dialog, which) -> dialog.dismiss());
        // Create the dialog
        AlertDialog dialog = builder.create();
        // Show it
        dialog.show();
    }


    /*************** CLASSES *************/

    // audio class [inspired from: https://github.com/billthefarmer/scope; accessed: July 2020]
    protected class Audio implements Runnable {
        private static final String TAG = "Frequency";

        protected int input;
        protected int sample;
//        protected boolean lock;
        protected boolean fill;
        protected boolean hold;

        // Data
        protected double frequency;
        protected double fps;

        private AudioRecord audioRecord;

        private static final int OVERSAMPLE = 4;
        private static final int SAMPLES = 4096;
        private static final int RANGE = SAMPLES / 2;
        private static final int STEP = SAMPLES / OVERSAMPLE;

        // N8 M32
        private static final int N = 8;
        private static final int M = 32;

        private static final double MIN = 0.5;
        private static final double expect = 2.0 * Math.PI * STEP / SAMPLES;

        private long counter;

        private Thread thread;
        private short[] data;
        private double[] buffer;

        private double[] xr;
        private double[] xi;

        protected double[] xa;
        protected double[] xm;

        private double[] xp;
        private double[] xf;

        // Constructor
        protected Audio()
        {
            data = new short[STEP];
            buffer = new double[SAMPLES];

            xr = new double[SAMPLES];
            xi = new double[SAMPLES];

            xa = new double[RANGE];
            xm = new double[RANGE];
            xp = new double[RANGE];
            xf = new double[RANGE];
        }

        // Start audio
        protected void start()
        {
            // Start the thread
            thread = new Thread(this, "Audio");
            thread.start();
        }

        // Run
        @Override
        public void run()
        {
            processAudio();
        }

        // Stop
        protected void stop()
        {
            // Stop and release the audio recorder
            cleanUpAudioRecord();

            Thread t = thread;
            thread = null;

            try
            {
                // Wait for the thread to exit
                if (t != null && t.isAlive())
                    t.join();
            }

            catch (Exception e) {}
        }

        // Stop and release the audio recorder
        private void cleanUpAudioRecord()
        {
            if (audioRecord != null &&
                    audioRecord.getState() == AudioRecord.STATE_INITIALIZED)
            {
                try
                {
                    if (audioRecord.getRecordingState() ==
                            AudioRecord.RECORDSTATE_RECORDING)
                        audioRecord.stop();

                    audioRecord.release();
                }

                catch (Exception e) {}
            }
        }

        // Process Audio
        protected void processAudio()
        {
            // Assume the output sample will work on the input as
            // there isn't an AudioRecord.getNativeInputSampleRate()
            sample = AudioTrack.getNativeOutputSampleRate(AudioManager.STREAM_MUSIC);

            // Calculate fps
            fps = (double) sample / SAMPLES;

            // Get buffer size
            int size =
                    AudioRecord.getMinBufferSize(sample,
                            AudioFormat.CHANNEL_IN_MONO,
                            AudioFormat.ENCODING_PCM_16BIT);
            // Give up if it doesn't work
            if (size == AudioRecord.ERROR_BAD_VALUE ||
                    size == AudioRecord.ERROR ||
                    size <= 0)
            {
                runOnUiThread(() -> showAlert(
                        R.string.error_buffer));

                thread = null;
                return;
            }

            // Create the AudioRecord object
            try
            {
                audioRecord =
                        new AudioRecord(input, sample,
                                AudioFormat.CHANNEL_IN_MONO,
                                AudioFormat.ENCODING_PCM_16BIT,
                                size);
            }

            // Exception
            catch (Exception e)
            {
                runOnUiThread(() -> showAlert(
                        R.string.error_init));

                thread = null;
                return;
            }

            // Check audiorecord

            // Check state
            int state = audioRecord.getState();

            if (state != AudioRecord.STATE_INITIALIZED)
            {
                runOnUiThread(() -> showAlert(
                        R.string.error_init));

                audioRecord.release();
                thread = null;
                return;
            }

            // Start recording
            audioRecord.startRecording();

            // Max data
            double dmax = 0.0;

            // Max spectrum
            Arrays.fill(xm, 0.0);

            // Continue until the thread is stopped
            while (thread != null)
            {
                // Read a buffer of data
                size = audioRecord.read(data, 0, STEP);

                // Stop the thread if no data or error state
                if (size <= 0)
                {
                    thread = null;
                    break;
                }

                // Move the main data buffer up
                System.arraycopy(buffer, STEP, buffer, 0, SAMPLES - STEP);

                for (int i = 0; i < STEP; i++)
                    buffer[(SAMPLES - STEP) + i] = data[i];

                // Maximum value
                if (dmax < 4096.0)
                    dmax = 4096.0;

                // Calculate normalising value
                double norm = dmax;

                dmax = 0.0;

                // Copy data to FFT input arrays
                for (int i = 0; i < SAMPLES; i++)
                {
                    // Find the magnitude
                    if (dmax < Math.abs(buffer[i]))
                        dmax = Math.abs(buffer[i]);

                    // Calculate the window
                    double window =
                            0.5 - 0.5 * Math.cos(2.0 * Math.PI *
                                    i / SAMPLES);

                    // Normalise and window the input data
                    xr[i] = buffer[i] / norm * window;
                }

                // do FFT
                fftr(xr, xi);

                // Process FFT output
                for (int i = 1; i < RANGE; i++)
                {
                    double real = xr[i];
                    double imag = xi[i];

                    // Get the magnitude
                    xa[i] = Math.hypot(real, imag);

                    // Do max spectrum calculation
                    if (xm[i] < xa[i])
                        xm[i] = xa[i];

                    else
                        xm[i] = ((xm[i] * 49.0) + xa[i]) / 50.0;

                    // Do frequency calculation
                    double p = Math.atan2(imag, real);
                    double dp = xp[i] - p;

                    xp[i] = p;

                    // Calculate phase difference
                    dp -= i * expect;

                    int qpd = (int) (dp / Math.PI);

                    if (qpd >= 0)
                        qpd += qpd & 1;

                    else
                        qpd -= qpd & 1;

                    dp -= Math.PI * qpd;

                    // Calculate frequency difference
                    double df = OVERSAMPLE * dp / (2.0 * Math.PI);

                    // Calculate actual frequency from slot frequency plus
                    // frequency difference and correction value
                    xf[i] = i * fps + df * fps;
                }

                // Do a full process run every N
                if (++counter % N != 0)
                    continue;

                // Check display lock
                if (lock)
                    continue;

                // Update frequency and dB every M
                if (counter % M != 0)
                    continue;

                // Maximum FFT output
                double max = 0.0;

                // Find maximum value
                for (int i = 1; i < RANGE; i++)
                {
                    if (xa[i] > max)
                    {
                        max = xa[i];
                        frequency = xf[i];
                    }
                }

                // Level
                double level = 0.0;

                for (int i = 0; i < STEP; i++)
                    level += ((double) data[i] / 32768.0) *
                            ((double) data[i] / 32768.0);

                level = Math.sqrt(level / STEP) * 2.0;

                double dB = Math.log10(level) * 20.0;

//                if (dB < -80.0)
//                    dB = -80.0;

                // Update frequency and dB display
                if (max > MIN)
                {
                    final String s = String.format(Locale.getDefault(),
                            "%1.1fHz %1.1fdB",frequency, dB);
                    feedbackFreq.post(() -> feedbackFreq.setText(s));
                }
                else
                {
                    frequency = 0.0;
                    final String s = "freq";
                    feedbackFreq.post(() -> feedbackFreq.setText(s));
                }

                // if specific frequency detected, get distance
                if ((getfeedbackFreq() - getfeedbackFreqOffset()) < frequency && frequency < (getfeedbackFreq() + getfeedbackFreqOffset())) {
                    // get the system counting time when condition meet
                    beepReceptionTime = SystemClock.uptimeMillis();
                    // wait to play the receiving beep

                    // in v3 has been changed to % distance accuracy
//                    sysTimeIn.post(() -> sysTimeIn.setText(String.valueOf(beepReceptionTime)));

                    // show the delay; beep durations, offsets, added time, system delays ar included in beepReceptionTime
                    // check if oneLoop is active
                    if (oneLoop = oneLoopBox.isChecked()) {
                        beepFeedbackTime = beepStartTime;
                    }

                    // delay has been changed to level value
                    delay.post(() -> delay.setText(String.format(Locale.getDefault(), "%1.2f", dB)));

                    // show current frequency that meet condition
                    feedbackDuration.post(() -> feedbackDuration.setText(String.valueOf((int) frequency)));

                    // call function and show distance, use sound level to calculate it in this version (3.0)
                    final double mLevel = Math.abs(dB/6*getDelayOffsetValue());
                    distance.post(() -> distance.setText(String.format(Locale.getDefault(), "%1.2f", mLevel)));
//                    distance.post(() -> distance.setText(String.valueOf(mLevel)));

                    // in v3 write a new value of accuracy instead of time
                    if (getTemp() > mLevel) {
                        sysTimeIn.post(() -> sysTimeIn.setText(String.format(Locale.getDefault(), "%1.2f",(mLevel / getTemp() * 100))));
                    } else {
                        sysTimeIn.post(() -> sysTimeIn.setText(String.format(Locale.getDefault(), "%1.2f",(getTemp() / mLevel * 100))));
                    }

                    //wait beeps to finish
                    try {
                        Thread.sleep(getDuration());
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }

                    // send feedback beep
                    sendFeedbackBeep();
                }
            }

            // Stop and release the audio recorder
            cleanUpAudioRecord();
        }

        public void sendFeedbackBeep() {
            // check if oneLoop is active
            if (oneLoop = oneLoopBox.isChecked()) {
                beepReturn = beepGenerator(getFreq(), getDuration());
                beepReturn.play();
                getBeepReturnDuration();
                lock = true;
                return;
            }

            // play the feedback and consider this time as being the start time for the feedback phone2
            beepReturn = beepGenerator(getFreq(), getDuration());
            beepFeedbackTime = SystemClock.uptimeMillis();
            sysTimeOut.post(() -> sysTimeOut.setText(String.valueOf(beepFeedbackTime)));
            beepReturn.play();
//            try {
//                Thread.sleep(getDuration() + getDuration()/2);
//            } catch (InterruptedException e) {
//                e.printStackTrace();
//            }
            getBeepReturnDuration();

            // display values on screen
//            feedbackDuration.post(() -> feedbackDuration.setText(String.valueOf((int) frequency)));
//            sysTimeOut.post(() -> sysTimeOut.setText(String.valueOf(beepReceptionTime)));
//            sysTimeIn.post(() -> sysTimeIn.setText(String.valueOf(beepFeedbackTime)));
//            delay.post(() -> delay.setText(String.valueOf(beepFeedbackTime - beepReceptionTime)));
//            distance.post(() -> distance.setText(showDistance()));

            // TODO while reading frequency and detect if stay the same for 100ms, make a loop related to it;
            //  count something as duration > 100 ms and increment it gradually to make an automatic loop

//                Log.d(logMsg,"settings:" + getfeedbackFreqOffset());
//                if (frequency > comparator - 10) {
//                    //increment the comparative value
//                    if (comparator < 3100) {
//                        comparator = comparator + 100;
//                    } else{
//                        comparator = getFreq();
//                    }
            // daca are si o anumita durata atunci ia timpul de la sfarsitul beepului
//                if (3095 < frequency && frequency < 3105) {

//            do {
            // get the system counting time when condition meet
//                beepReceptionTime = SystemClock.uptimeMillis();

            // while condition is still active, wait! than execute the beep // wait to make 1000 ms including beep duration
//                try {
//                    thread.sleep(getDuration());
//                } catch (InterruptedException e) {
//                    e.printStackTrace();
//                }

            // TODO send back the same frequency beep, will need to calculate the beep length or just use the protocol
            //lock the thread, for a snapshot
            //                    lock = true;
            //            } while ((getfeedbackFreq() - getfeedbackFreqOffset()) > frequency && frequency > (getfeedbackFreq() + getfeedbackFreqOffset()));
        }

        // beepReturn AudioTrack cleaning
        private void getBeepReturnDuration() {
                //if beep stopped, get the current emitted duration
                if (beepReturn != null) {

                    if (beepReturn.getPlayState() != AudioTrack.PLAYSTATE_PAUSED) {

                        // setNotificationMarkerPosition(frames); for beep tracking: set the played buffer size in frames(bytes/2) not bytes
                        beepReturn.setNotificationMarkerPosition((int) (44100.0 * (getDuration() / 1000.0)) & ~1);

                        // setPlaybackPositionUpdateListener will check AudioTrack position, beep frames position
                        beepReturn.setPlaybackPositionUpdateListener(new AudioTrack.OnPlaybackPositionUpdateListener() {
                            @Override
                            public void onPeriodicNotification(AudioTrack track) {
                                // this method even not used, have to be here
                            }

                            //will check if the previous marker position value has reach the end (filled up)
                            @Override
                            public void onMarkerReached(AudioTrack track) {
                                // get the end time of playing beep
//                            beepFeedbackTime = SystemClock.uptimeMillis();

//                            long time = (beepFeedbackTime - beepStartTime);
//                            sysTimeOut.setText(String.valueOf(time));
                                // TODO why is getting a strange time? lower than initial??!

                                //display the duration of played beep
                                long calculatedBeepDuration = Math.round(beepReturn.getPlaybackHeadPosition() / 44100.0 * 1000);
                                beepEmittedDuration.post(() -> beepEmittedDuration.setText(String.valueOf(calculatedBeepDuration)));

                                Log.d(logMsg, "the beepReturn have been played!" + beepReturn.getPlaybackHeadPosition());
//                        lock = true;
                                beepReturn.flush();
                                beepReturn.release();
                            }
                        });

                    } else {
//                    // get the end time of playing beep
//                    beepFeedbackTime = SystemClock.uptimeMillis();
//                    long time = (beepFeedbackTime - beepStartTime);
//                    sysTimeOut.setText(String.valueOf(time));

                        //display the duration of played beep
                        long calculatedBeepDuration = Math.round(beepReturn.getPlaybackHeadPosition() / 44100.0 * 1000);
                        beepEmittedDuration.post(() -> beepEmittedDuration.setText(String.valueOf(calculatedBeepDuration)));
                        Log.d(logMsg, "the beepReturn else!" + beepReturn.getPlaybackHeadPosition());
                    }
                }
        }

        //distance calculation knowing the delay and air temperature
        String showDistance() {
            double delayMs = beepReceptionTime - beepFeedbackTime - getDuration() * getDelayOffsetValue();
            double soundSpeed = 331.3 + (0.6 * getTemp());
            return (String.valueOf((int)(soundSpeed/1000 * delayMs)));
        }

        // Real to complex FFT, ignores imaginary values in input array
        private void fftr(double[] ar, double[] ai)
        {
            final int n = ar.length;
            final double norm = Math.sqrt(1.0 / n);

            for (int i = 0, j = 0; i < n; i++)
            {
                if (j >= i)
                {
                    double tr = ar[j] * norm;

                    ar[j] = ar[i] * norm;
                    ai[j] = 0.0;

                    ar[i] = tr;
                    ai[i] = 0.0;
                }

                int m = n / 2;
                while (m >= 1 && j >= m)
                {
                    j -= m;
                    m /= 2;
                }
                j += m;
            }

            for (int mmax = 1, istep = 2 * mmax; mmax < n;
                 mmax = istep, istep = 2 * mmax)
            {
                double delta = Math.PI / mmax;
                for (int m = 0; m < mmax; m++)
                {
                    double w = m * delta;
                    double wr = Math.cos(w);
                    double wi = Math.sin(w);

                    for (int i = m; i < n; i += istep)
                    {
                        int j = i + mmax;
                        double tr = wr * ar[j] - wi * ai[j];
                        double ti = wr * ai[j] + wi * ar[j];
                        ar[j] = ar[i] - tr;
                        ai[j] = ai[i] - ti;
                        ar[i] += tr;
                        ai[i] += ti;
                    }
                }
            }
        }
    }

    // one class for any popup in menu or anything
    public static class ViewPopup {
        //CharSequence to retain text formatting and use getText(R.string.anyID)
        public void showDialog(Activity activity, String title, CharSequence text){
            final Dialog popup = new Dialog(activity);

            popup.requestWindowFeature(Window.FEATURE_NO_TITLE);
            popup.setContentView(R.layout.popup);
            Objects.requireNonNull(popup.getWindow()).setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));

            TextView titlePopup = (TextView) popup.findViewById(R.id.title_popup);
            titlePopup.setText(title);

            TextView textPopup = (TextView) popup.findViewById(R.id.text_popup);
            textPopup.setMovementMethod(LinkMovementMethod.getInstance());
            textPopup.setText(text);

            Button closePopup = popup.findViewById(R.id.close_popup);
            closePopup.setOnClickListener(v -> popup.cancel());

            popup.show();
        }
    }

    // class to send data to a server
    // [inspired from: https://www.includehelp.com/android/sending-data-on-server-through-an-android-application.aspx; accessed: July 2020]
    @SuppressLint("StaticFieldLeak")
    public class CallHttpRequest extends AsyncTask<String,Void,String> {

        @Override
        protected String doInBackground(String... url) {
//            if(process.equals("send")) {
            return callRequest (url[0]);
//            }
//            return  null;
    }
        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            try {
                if(s.equals("true"))
                    Toast.makeText(getBaseContext(), "Data send!", Toast.LENGTH_SHORT).show();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        String callRequest(String Url) {
            try {
                URL url = new URL(Url);
                HttpURLConnection con = (HttpURLConnection) url.openConnection();
                con.setRequestMethod("POST");
                con.setDoInput(true);
                BufferedReader in=new BufferedReader(new InputStreamReader(con.getInputStream()));
                StringBuilder output = new StringBuilder();
                String str;

                while ((str = in.readLine()) != null) {
                    output.append(str);
                }
                in.close();
                return (output.toString());
            } catch (Exception e) {
                e.printStackTrace();
            }
            return (null);
        }
    }

}
