package com.example.disttone;

import android.app.AlertDialog;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Environment;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;

import androidx.appcompat.app.AppCompatActivity;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class SettingsActivity extends AppCompatActivity {

    // define user interface elements
    EditText feedbackFreqOffset;
    Button saveLogs, deleteLogs, resetToDefault;

    // same value of "storedSettings" in all activities, to share settings/preferences between them
    public static final String savedSettings = "storedSettings";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_settings);

        feedbackFreqOffset = findViewById(R.id.feedbackFreqOffset);
        saveLogs = findViewById(R.id.saveLogs);
        deleteLogs = findViewById(R.id.deleteLogs);
        resetToDefault = findViewById(R.id.resetToDefault);

        // get last value of offset
        feedbackFreqOffset.setText(getSettingsValue());

        // set new value for offset after editing text
        feedbackFreqOffset.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {}
            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {}
            @Override
            public void afterTextChanged(Editable s) {
                if (s.length() > 0) {
                    setSettingsValue("freqOffset", feedbackFreqOffset.getText().toString());
                }
            }
        });

        // save logs on click button ith confirmation dialog
        saveLogs.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                // Create a confirmation alert dialog buildDialog
                AlertDialog.Builder buildDialog = new AlertDialog.Builder(SettingsActivity.this);
                // Set title, message and buttons
                buildDialog.setTitle(R.string.app_name);
                buildDialog.setMessage("It will rewrite any previous saved disttonelogs.txt file in Download folder! \nContinue?");
                buildDialog.setPositiveButton("Save", (dialog, which) -> saveLogsToFile());
                buildDialog.setNegativeButton("Cancel", (dialog, which) -> dialog.cancel());
                buildDialog.setNeutralButton("Close", (dialog, which) -> dialog.dismiss());
                // Create the dialog
                AlertDialog confirmDialog = buildDialog.create();
                // Show it
                confirmDialog.show();
            }
        });

        // delete logs in click button with confirmation dialog
        deleteLogs.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                // Create a confirmation alert dialog buildDialog
                AlertDialog.Builder buildDialog = new AlertDialog.Builder(SettingsActivity.this);
                // Set title, message and buttons
                buildDialog.setTitle(R.string.app_name);
                buildDialog.setMessage("Are you sure you want to permanently DELETE ALL logs from local database?");
                buildDialog.setPositiveButton("Delete", (dialog, which) -> deleteAllLogRecords());
                buildDialog.setNegativeButton("Cancel", (dialog, which) -> dialog.cancel());
                buildDialog.setNeutralButton("Close", (dialog, which) -> dialog.dismiss());
                // Create the dialog
                AlertDialog confirmDialog = buildDialog.create();
                // Show it
                confirmDialog.show();
            }
        });

        // reset to default
        resetToDefault.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                // Create a confirmation alert dialog buildDialog
                AlertDialog.Builder buildDialog = new AlertDialog.Builder(SettingsActivity.this);
                // Set title, message and buttons
                buildDialog.setTitle(R.string.app_name);
                buildDialog.setMessage("Are you sure you want to reset all values to default ones?");
                buildDialog.setPositiveButton("Reset", (dialog, which) -> {
                        setSettingsValue("beepFreq", "4300");
                    setSettingsValue("beepDuration", "500");
                    setSettingsValue("feedbackBeepFreq", "4000");
                    setSettingsValue("airTemp", "0.5");
                    setSettingsValue("freqOffset", "10");
                    setSettingsValue("delayOffset", "1.00");});
                buildDialog.setNegativeButton("Cancel", (dialog, which) -> dialog.cancel());
                buildDialog.setNeutralButton("Close", (dialog, which) -> dialog.dismiss());
                // Create the dialog
                AlertDialog confirmDialog = buildDialog.create();
                // Show it
                confirmDialog.show();
            }
        });
    }

    // get settings
    public String getSettingsValue() {
        SharedPreferences settings = getSharedPreferences(savedSettings,0);
        return settings.getString("freqOffset","5");
    }

    // set settings
//    public void setSettingsValue(String freqOffsetValue) {
//        SharedPreferences.Editor editor = getSharedPreferences(savedSettings,0).edit();
//        editor.putString("freqOffset", freqOffsetValue);
//        editor.apply();
//    }

    // set settings using SharedPreferences internal storage in savedSettings = "storedSettings"
    public void setSettingsValue(String editedParamKey, String editedParamKeyValue) {
        SharedPreferences.Editor editor = getSharedPreferences(savedSettings,0).edit();
        editor.putString(editedParamKey, editedParamKeyValue);
        editor.apply();
    }

    // save the log to download folder
    private void saveLogsToFile() {
        // get all log records in an array
        LogDatabase logDatabaseFile = new LogDatabase(SettingsActivity.this);
        ArrayList<ALogRecord> showAllRecordsFile = logDatabaseFile.returnAllLogRecords();

        try {
            // create a file in Download folder; if the file does not exists, it is created
            File logFile = new File(Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_DOWNLOADS), "disttonelogs.txt");
            if (!logFile.exists())
                logFile.createNewFile();
            // add content to file; append: true - add new records to the existing ones
            BufferedWriter writer = new BufferedWriter(new FileWriter(logFile, false /*append*/));
            writer.write("- - - < Start of records > - - -" + "\n");
            writer.write(getResources().getString(R.string.log_description) + "\n\n");
            if (showAllRecordsFile.size() > 0) {
                // get all records formatted in descendant order
                for (ALogRecord rec : showAllRecordsFile) {
                    writer.append(rec.getLog_id() + " | " +  rec.getLog_beepFreq() + " | " +
                            rec.getLog_beep_duration() + " | " +  rec.getLog_feedbackBeepFreq() + " | " +
                            rec.getLog_sysTimeOut() + " | " +  rec.getLog_sysTimeIn() + " | " +
                            rec.getLog_delay() + " | " +  rec.getLog_airTemp() + " | " +
                            rec.getLog_distance() + " | " +  rec.getLog_phoneDate() );
                    writer.append("\n");
                    writer.append(getResources().getString(R.string.log_separation));
                    writer.append("\n");
                }
            }
            writer.append("- - - < End of records > - - -");
            writer.close();
            Toast.makeText(this, "Success! Check the Download folder!",Toast.LENGTH_SHORT).show();
        } catch (
                IOException e) {
            Log.e("Write logFile", "Error on writing the file!");
        }
    }

    // delete logs
    private void deleteAllLogRecords() {
        LogDatabase logDatabaseDel = new LogDatabase(SettingsActivity.this);
        //logDatabaseDel.deleteAllLogRecords();
        Toast.makeText(getBaseContext(), "All " + logDatabaseDel.deleteAllLogRecords() + " logs have been deleted!",
                Toast.LENGTH_SHORT).show();
    }

}